INFOSOLO database


USE infosolo;


Table methods

CREATE TABLE infosolo.methods (
   ID3 INTEGER NOT NULL,
   Method VARCHAR(250),
   Reference_M VARCHAR(500),
   Parameter VARCHAR(30),
   PRIMARY KEY (ID3)
 )
Engine=InnoDB;

LOAD DATA LOCAL INFILE 'C:/INFOSOLO/methods.txt'
INTO TABLE infosolo.methods
LINES TERMINATED BY '\r\n';


Table soil

CREATE TABLE infosolo.soil (
   ID1 INTEGER NOT NULL AUTO_INCREMENT,
   Profile_ID VARCHAR(15) NOT NULL,
   Longitude FLOAT(8,6),
   Latitude FLOAT(8,6),
   Z INT(4),
   Coordinates VARCHAR(15),
   Year_ YEAR(4),
   Soil VARCHAR(15),
   Qualifier1 VARCHAR(20),
   Qualifier2 VARCHAR(20),
   Qualifier3 VARCHAR(20),
   WRB_M INTEGER,
   Parent_Material VARCHAR(50),
   Land_USE VARCHAR(30),
   Institution VARCHAR(100),
   Reference VARCHAR(500), 
   PRIMARY KEY (ID1),
   FOREIGN KEY (WRB_M) REFERENCES methods(ID3)
 )
Engine=InnoDB;

LOAD DATA LOCAL INFILE 'C:/INFOSOLO/soil.txt'
INTO TABLE infosolo.soil
LINES TERMINATED BY '\r\n';


Table properties

CREATE TABLE infosolo.properties (
   ID2 INTEGER NOT NULL AUTO_INCREMENT,
   ID1 INTEGER NOT NULL,
   Hor_top FLOAT(4,1),
   Hor_bot FLOAT(4,1),
   Hor_name VARCHAR(10),
   Coarse FLOAT(3,1),
   CS FLOAT(3,1),
   FS FLOAT(3,1),
   Si FLOAT(3,1),
   C FLOAT(3,1),
   Texture_M INTEGER,
   BD FLOAT(3,2),
   BD_M INTEGER,
   OC FLOAT(4,2),
   OC_M INTEGER,
   N FLOAT(4,2),
   N_M INTEGER,
   P FLOAT(5,1),
   P_M INTEGER,
   K FLOAT(5,1),
   K_M INTEGER,
   pH FLOAT(3,1),
   pH_M INTEGER,
   CaCO3 FLOAT(3,1),
   CaCO3_M INTEGER,
   Ca_ex FLOAT(4,2),
   Mg_ex FLOAT(4,2),
   K_ex FLOAT(4,2),
   Na_ex FLOAT(4,2),
   Cations_M INTEGER,
   CEC FLOAT(4,2),
   CEC_M INTEGER,
   V FLOAT(4,1),
   Theta_FC FLOAT(5,4),
   Theta_WP FLOAT(5,4),
   Theta_M INTEGER,
   PRIMARY KEY (ID2),
   FOREIGN KEY (ID1) REFERENCES soil(ID1),
   FOREIGN KEY (Texture_M) REFERENCES methods(ID3),
   FOREIGN KEY (BD_M) REFERENCES methods(ID3),
   FOREIGN KEY (OC_M) REFERENCES methods(ID3),
   FOREIGN KEY (N_M) REFERENCES methods(ID3),
   FOREIGN KEY (P_M) REFERENCES methods(ID3),
   FOREIGN KEY (K_M) REFERENCES methods(ID3),
   FOREIGN KEY (pH_M) REFERENCES methods(ID3),
   FOREIGN KEY (CaCO3_M) REFERENCES methods(ID3),
   FOREIGN KEY (Cations_M) REFERENCES methods(ID3),
   FOREIGN KEY (CEC_M) REFERENCES methods(ID3),
   FOREIGN KEY (Theta_M) REFERENCES methods(ID3)
 )
Engine=InnoDB;

LOAD DATA LOCAL INFILE 'C:/INFOSOLO/properties.txt'
INTO TABLE infosolo.properties
LINES TERMINATED BY '\r\n';


Table description

CREATE TABLE infosolo.description (
   ID4 INTEGER NOT NULL AUTO_INCREMENT,
   Property VARCHAR(15),
   Table_ID VARCHAR(15),
   description VARCHAR(200),
   units VARCHAR(15),
   PRIMARY KEY (ID4)
 )
Engine=InnoDB;

LOAD DATA LOCAL INFILE 'C:/INFOSOLO/description.txt'
INTO TABLE infosolo.description
LINES TERMINATED BY '\r\n';



